<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;

/**
 * UserTokenList
 *
 * @ORM\Table(name="user_tokens_lists")
 * @ORM\Entity
 *
 * @ORM\HasLifecycleCallbacks
 * @ExclusionPolicy("all")
 */
class UserTokenList
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="user_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details"})
     */
    private $userId;

    /**
     * @var integer
     *
     * @ORM\Column(name="sequence", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $sequence;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="create_at", type="datetime")
     *
     * @Expose
     * @AnnotationGroups({"details"})
     */
    private $createAt;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_active", type="boolean")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $isActive;

    /**
     * @var integer
     *
     * @ORM\Column(name="generate_by_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details"})
     */
    private $generateById;


    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="tokensList")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @ORM\ManyToOne(targetEntity="User")
     * @ORM\JoinColumn(name="generate_by_id", referencedColumnName="id")
     */
    protected $generateBy;

    /**
     * @ORM\OneToMany(targetEntity="UserToken", mappedBy="tokenList", cascade={"remove"})
     * @ORM\OrderBy({"sequence"="ASC"})
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    protected $tokens;


    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createAt = new \DateTime();
    }



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set userId
     *
     * @param integer $userId
     * @return UserTokenList
     */
    public function setUserId($userId)
    {
        $this->userId = $userId;
    
        return $this;
    }

    /**
     * Get userId
     *
     * @return integer 
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return UserTokenList
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }

    /**
     * Set isActive
     *
     * @param boolean $isActive
     * @return UserTokenList
     */
    public function setIsActive($isActive)
    {
        $this->isActive = $isActive;
    
        return $this;
    }

    /**
     * Get isActive
     *
     * @return boolean 
     */
    public function getIsActive()
    {
        return $this->isActive;
    }

    /**
     * Set generateById
     *
     * @param integer $generateById
     * @return UserTokenList
     */
    public function setGenerateById($generateById)
    {
        $this->generateById = $generateById;
    
        return $this;
    }

    /**
     * Get generateById
     *
     * @return integer 
     */
    public function getGenerateById()
    {
        return $this->generateById;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->tokens = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Set user
     *
     * @param \VM\ApiBundle\Entity\User $user
     * @return UserTokenList
     */
    public function setUser(\VM\ApiBundle\Entity\User $user = null)
    {
        $this->user = $user;
    
        return $this;
    }

    /**
     * Get user
     *
     * @return \VM\ApiBundle\Entity\User 
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set generateBy
     *
     * @param \VM\ApiBundle\Entity\User $generateBy
     * @return UserTokenList
     */
    public function setGenerateBy(\VM\ApiBundle\Entity\User $generateBy = null)
    {
        $this->generateBy = $generateBy;
    
        return $this;
    }

    /**
     * Get generateBy
     *
     * @return \VM\ApiBundle\Entity\User 
     */
    public function getGenerateBy()
    {
        return $this->generateBy;
    }

    /**
     * Add tokens
     *
     * @param \VM\ApiBundle\Entity\UserToken $tokens
     * @return UserTokenList
     */
    public function addToken(\VM\ApiBundle\Entity\UserToken $tokens)
    {
        $this->tokens[] = $tokens;
    
        return $this;
    }

    /**
     * Remove tokens
     *
     * @param \VM\ApiBundle\Entity\UserToken $tokens
     */
    public function removeToken(\VM\ApiBundle\Entity\UserToken $tokens)
    {
        $this->tokens->removeElement($tokens);
    }

    /**
     * Get tokens
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTokens()
    {
        return $this->tokens;
    }

    /**
     * Set sequence
     *
     * @param integer $sequence
     * @return UserTokenList
     */
    public function setSequence($sequence)
    {
        $this->sequence = $sequence;
    
        return $this;
    }

    /**
     * Get sequence
     *
     * @return integer 
     */
    public function getSequence()
    {
        return $this->sequence;
    }
}